/*
 * Decompiled with CFR 0.152.
 */
package com.phonegap.build.android;

import com.phonegap.build.DreamweaverBase;
import com.phonegap.build.ProcessResult;
import com.phonegap.build.android.AndroidDevice;
import com.phonegap.build.android.AndroidException;
import com.phonegap.build.android.AndroidLog;
import com.phonegap.build.android.AndroidState;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Android
extends DreamweaverBase {
    public static void listSDKs(String sdkPath, String output) throws Exception {
        try {
            AndroidState state = AndroidState.GetCurrent(sdkPath);
            Android.write_json(output, state.toJSON());
        }
        catch (AndroidException ex) {
            Android.error(output, ex.getMessage());
        }
    }

    public static void launchAVDManager(String sdkPath) throws Exception {
        String androidExecutable = String.valueOf(sdkPath) + File.separator + "tools" + File.separator + "android" + (Android.isMac() ? "" : ".bat");
        Android.debug_log("Launching AVD manager");
        try {
            Android.commandLine(new String[]{androidExecutable, "avd"}, true, null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void run(String sdkPath, String appPath, String deviceName, String output) throws Exception {
        AndroidLog log = new AndroidLog("running", "");
        try {
            Android.run(log, sdkPath, appPath, deviceName, output);
            log.state = "success";
            Android.writeAndroidLog(output, log, "Application running");
        }
        catch (AndroidException ex) {
            log.state = "error";
            Android.writeAndroidLog(output, log, ex.getMessage());
        }
    }

    public static void createAVD(String sdkPath, String appPath, String deviceName, String output) throws Exception {
        try {
            Android.createAVD(sdkPath, appPath, deviceName);
            Android.success(output, "AVD created");
        }
        catch (AndroidException ex) {
            Android.error(output, ex.getMessage());
        }
    }

    private static void writeAndroidLog(String output, AndroidLog androidLog, String message) throws Exception {
        androidLog.AddLog(message);
        Android.write_json(output, androidLog.toJSON());
    }

    private static void run(AndroidLog log, String sdkPath, String appPath, String deviceName, String output) throws Exception {
        String emulatorExecutable = String.valueOf(sdkPath) + File.separator + "tools" + File.separator + "emulator" + (Android.isMac() ? "" : ".exe");
        String adbExecutable = String.valueOf(sdkPath) + File.separator + "platform-tools" + File.separator + "adb" + (Android.isMac() ? "" : ".exe");
        String aaptExecutable = String.valueOf(sdkPath) + File.separator + "platform-tools" + File.separator + "aapt" + (Android.isMac() ? "" : ".exe");
        Android.writeAndroidLog(output, log, "Finding device/emulator ...");
        AndroidState state = new AndroidState();
        state.updateDevices(adbExecutable);
        ProcessResult processResult = null;
        Android.debug_log("Finding device/emulator");
        AndroidDevice currentDevice = null;
        int i = 0;
        while (i < state.devices.size()) {
            AndroidDevice device = state.devices.get(i);
            if (device.name.contentEquals(deviceName)) {
                currentDevice = device;
                Android.debug_log("Found running device");
                if (currentDevice.isDevice.booleanValue()) {
                    Android.writeAndroidLog(output, log, "Found device");
                } else {
                    Android.writeAndroidLog(output, log, "Found running emulator");
                }
            }
            ++i;
        }
        if (currentDevice == null) {
            Android.writeAndroidLog(output, log, "Starting emulator: " + deviceName);
            Android.debug_log("Running emulator: " + deviceName);
            try {
                processResult = Android.commandLine(new String[]{emulatorExecutable, "-avd", deviceName, "-memory", "256"}, true, "");
            }
            catch (Exception ex) {
                Android.debug_log(ex.toString());
                throw new AndroidException("Cannot start emulator");
            }
            Thread.sleep(2000L);
            try {
                processResult = Android.commandLine(new String[]{adbExecutable, "kill-server"}, false, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                processResult = Android.commandLine(new String[]{adbExecutable, "start-server"}, false, null);
            }
            catch (Exception ex) {
                // empty catch block
            }
            Android.debug_log("Get serial");
            int j = 0;
            Boolean success = false;
            while (j < 12 && currentDevice == null) {
                Thread.sleep(5000L);
                state.updateDevices(adbExecutable);
                int i2 = 0;
                while (i2 < state.devices.size()) {
                    AndroidDevice device = state.devices.get(i2);
                    if (device.name.contentEquals(deviceName)) {
                        currentDevice = device;
                        success = true;
                        break;
                    }
                    ++i2;
                }
                ++j;
            }
            if (!success.booleanValue()) {
                throw new AndroidException("Cannot find emulator");
            }
            Android.debug_log("Wait for device");
            Android.writeAndroidLog(output, log, "Waiting for emulator ...");
            Android.debug_log("Wait for package manager");
            Thread.sleep(10000L);
            Boolean hasInitialised = false;
            int i3 = 0;
            success = false;
            while (i3 < 60) {
                Thread.sleep(5000L);
                processResult = Android.commandLine(new String[]{adbExecutable, "-s", currentDevice.serial, "shell", "pm", "path", "android"});
                if (processResult.process.exitValue() == 0) {
                    hasInitialised = true;
                    if (processResult.stdOut.startsWith("package")) {
                        success = true;
                        break;
                    }
                } else if (hasInitialised.booleanValue()) {
                    throw new AndroidException("Cannot find emulator");
                }
                ++i3;
            }
            if (!success.booleanValue()) {
                throw new AndroidException("Cannot find emulator");
            }
        }
        Android.debug_log("Unlocking emulator");
        processResult = Android.commandLine(new String[]{adbExecutable, "-s", currentDevice.serial, "shell", "input", "keyevent", "82"});
        Android.debug_log("Emulator unlocked");
        Android.debug_log("Install app");
        Android.writeAndroidLog(output, log, "Installing application ...");
        processResult = Android.commandLine(new String[]{adbExecutable, "-s", currentDevice.serial, "install", "-r", appPath});
        if (processResult.process.exitValue() > 0) {
            throw new AndroidException("Could not install application");
        }
        Android.debug_log("App installed");
        Android.debug_log("Run app");
        Android.writeAndroidLog(output, log, "Running application ...");
        processResult = Android.commandLine(new String[]{aaptExecutable, "dump", "badging", appPath});
        Pattern pattern = Pattern.compile("launchable-activity: name='(.*?)'", 8);
        Matcher m = pattern.matcher(processResult.stdOut);
        String activity = "";
        if (m.find()) {
            activity = m.group(1).trim();
        }
        activity = Android.replaceLast(activity, ".", "/.");
        Android.debug_log(activity);
        processResult = Android.commandLine(new String[]{adbExecutable, "-s", currentDevice.serial, "shell", "am", "start", "-a", "android.intent.action.MAIN", "-n", activity});
        if (processResult.process.exitValue() > 0) {
            throw new AndroidException("Could not run application");
        }
        Android.debug_log("App running");
    }

    private static void createAVD(String sdkPath, String target, String avdName) throws Exception {
        String androidExecutable = String.valueOf(sdkPath) + File.separator + "tools" + File.separator + "android" + (Android.isMac() ? "" : ".bat");
        Android.debug_log("Creating avd: " + avdName + " (id=" + target + ")");
        try {
            ProcessResult result = Android.commandLine(new String[]{androidExecutable, "create", "avd", "-n", avdName, "-t", target, "-f"}, false, "no");
            if (result.process.exitValue() > 0) {
                throw new AndroidException("Could not create AVD");
            }
        }
        catch (IOException ex) {
            throw new AndroidException("Could not create AVD");
        }
    }

    private static String replaceLast(String string, String from, String to) {
        int lastIndex = string.lastIndexOf(from);
        if (lastIndex < 0) {
            return string;
        }
        String tail = string.substring(lastIndex).replaceFirst(from, to);
        return String.valueOf(string.substring(0, lastIndex)) + tail;
    }
}

